$apppath="$env:USERPROFILE"+"\AppData\Local\MicroSIP\microsip.exe"

if (-not (Test-Path -Path $apppath -PathType leaf)) {
   Write-Host "Can't find the MicroSIP app"
   exit
}

Do {
    Write-Host "Checking if the server ims-i3-c1.rmg.local is reachable..."
    $HostUp = (Test-Connection -ComputerName ims-i3-c1.rmg.local -Count 2 -Quiet)
} Until ($HostUp)

curl.exe --silent --insecure --cert cert_i3-c1.pfx --user-agent "ININ-Softphone/4.0" --output "sipconfig.txt" "https://ims-i3-c1.rmg.local:8089/$env:COMPUTERNAME.i3sipcfg" 

if (Select-String -Quiet -Path "sipconfig.txt" -Pattern "Empty address") {
   echo "Failed to download configuration"
   exit
}

echo "Configuration downloaded from server"
#Select-String -Path "sipconfig.txt" -Pattern "SIPAddress" | Select-Object -ExpandProperty Line
#Select-String -Path "sipconfig.txt" -Pattern "SIPAuthUserName" | Select-Object -ExpandProperty Line
#Select-String -Path "sipconfig.txt" -Pattern "SIPAuthPassword" | Select-Object -ExpandProperty Line

[xml]$xmlDoc = Get-Content -Path "sipconfig.txt"

$SIPAddress = $xmlDoc.Provision.SIPAddress
$SIPAuthUserName = $xmlDoc.Provision.SIPAuthUserName
$SIPPassword = $xmlDoc.Provision.SIPAuthPassword

Write-Host "Credentials for manual configuration:"
Write-Host "SIP Server: ims-i3-c1.rmg.local:8060"
Write-Host "SIP Username: $env:COMPUTERNAME"
Write-Host "SIP Authentication user: $SIPAuthUserName"
Write-Host "SIP Password: $SIPPassword"

$cfgpath="$env:USERPROFILE"+"\AppData\Roaming\MicroSIP\microsip.ini"

# check if app is running, kill it
$process = Get-Process -Name "microsip" -ErrorAction SilentlyContinue
if ($process) {
   taskkill /IM microsip.exe
   while ($process) {
      Write-Host "Killing the app and waiting for it to end..."
      sleep 3
      $process = Get-Process -Name "microsip" -ErrorAction SilentlyContinue      
   }
}

if (Test-Path -Path $cfgpath -PathType leaf) {
   Write-Host "Deleting existing config..."
   del $cfgpath
}

Write-Host "Starting app to create initial config file..."
start $apppath

Do {
    Write-Host "Waiting for config file to be populated..."
    sleep 3
    $cfgok = ((Get-Item -Path $cfgPath).Length -gt 0)
} Until ($cfgok)

# check if app is running, kill it
$process = Get-Process -Name "microsip" -ErrorAction SilentlyContinue
if ($process) {
   taskkill /IM microsip.exe
   while ($process) {
      Write-Host "Killing the app and waiting for it to end..."
      sleep 3
      $process = Get-Process -Name "microsip" -ErrorAction SilentlyContinue      
   }
}

Start-Sleep -s 5
Write-Host "Configuring app..."
(Get-Content -Path $cfgpath) -replace ".*accountId=.*", "accountId=1" | Set-Content -Path $cfgpath
(Get-Content -Path $cfgpath) -replace ".*audioCodecs=.*", "audioCodecs=PCMU/8000/1 G729/8000/1" | Set-Content -Path $cfgpath
(Get-Content -Path $cfgpath) -replace ".*disableMessaging=.*", "disableMessaging=1" | Set-Content -Path $cfgpath
(Get-Content -Path $cfgpath) -replace ".*disableVideo=.*", "disableVideo=1" | Set-Content -Path $cfgpath
(Get-Content -Path $cfgpath) -replace "STUN=.*", "STUN=stun.rmg.local" | Set-Content -Path $cfgpath
(Get-Content -Path $cfgpath) -replace "enableSTUN=.*", "enableSTUN=1" | Set-Content -Path $cfgpath
(Get-Content -Path $cfgpath) -replace ".*autoAnswer=.*", "autoAnswer=all" | Set-Content -Path $cfgpath
(Get-Content -Path $cfgpath) -replace ".*headsetSupport=.*", "headsetSupport=1" | Set-Content -Path $cfgpath
Add-Content -Path $cfgpath -Value "[Account1]"
Add-Content -Path $cfgpath -Value "label=$SIPAddress"
Add-Content -Path $cfgpath -Value "server=ims-i3-c1.rmg.local:8060"
Add-Content -Path $cfgpath -Value "proxy="
Add-Content -Path $cfgpath -Value "domain=ims-i3-c1.rmg.local:8060"
Add-Content -Path $cfgpath -Value "username=$SIPAddress"
Add-Content -Path $cfgpath -Value "password=$SIPPassword"
Add-Content -Path $cfgpath -Value "authID=$SIPAuthUserName"
Add-Content -Path $cfgpath -Value "displayName="
Add-Content -Path $cfgpath -Value "dialingPrefix="
Add-Content -Path $cfgpath -Value "dialPlan="
Add-Content -Path $cfgpath -Value "hideCID=0"
Add-Content -Path $cfgpath -Value "voicemailNumber="
Add-Content -Path $cfgpath -Value "transport=udp"
Add-Content -Path $cfgpath -Value "publicAddr="
Add-Content -Path $cfgpath -Value "SRTP="
Add-Content -Path $cfgpath -Value "registerRefresh=300"
Add-Content -Path $cfgpath -Value "keepAlive=15"
Add-Content -Path $cfgpath -Value "publish=0"
Add-Content -Path $cfgpath -Value "ICE=0"
Add-Content -Path $cfgpath -Value "allowRewrite=0"
Add-Content -Path $cfgpath -Value "disableSessionTimer=0"

Write-Host "Starting app ..."
start $apppath

Write-Host "Press any key to continue..."
$key = [System.Console]::ReadKey("NoEcho,IncludeKeyDown")
